UNIT SORT;

{  Ten modul zawiera opisy procedur, ktore sa realizacjami algorytmow  de-
monstrowanych w module SORTING systemu DISC-MATH w pakiecie EI.
   Krotki opis algorytmow zrealizowanych w tych procedurach  znajduje  sie
w dokumentacji systemu DISC-MATH, a ich szczegolowe omowienie  mozna  zna-
lezc w literaturze przedmiotu zacytowanej w dokumentacji.
   Autorami opisow procedur sa Radoslaw Pruchnik i Mariusz Rudnicki.  }

INTERFACE
{R+}
CONST  rozmiar_tablic=100;
TYPE
            typ=INTEGER;
        tablice=ARRAY[1..rozmiar_tablic] OF typ;

PROCEDURE BubbleSort(VAR tabl:tablice; dol,gora:typ);

PROCEDURE HeapSort(VAR tabl:tablice; dol,gora:typ);

PROCEDURE InsertionSort(VAR tabl:tablice; dol,gora:typ);

PROCEDURE MergeSort(VAR tabl:tablice; dol,gora:typ);

PROCEDURE QuickSort(VAR tabl:tablice; dol,gora:typ);

PROCEDURE SelectionSort(VAR tabl:tablice; dol,gora:typ);

PROCEDURE ShellSort(VAR tabl:tablice; dol,gora:typ);

IMPLEMENTATION

PROCEDURE zamien(VAR x,y:typ);
   VAR v:typ;
BEGIN
   v:=x;   x:=y;   y:=v
END;  {zanmien}

PROCEDURE BubbleSort(VAR tabl:tablice; dol,gora:typ);
   VAR
      babelek,ostatnio_przestawiony:typ;
  BEGIN
    WHILE gora>dol DO BEGIN
      ostatnio_przestawiony:=dol;
      FOR babelek:=dol TO gora-1 DO
        IF tabl[babelek]>tabl[babelek+1] THEN BEGIN
          zamien(tabl[babelek],tabl[babelek+1]);
          ostatnio_przestawiony:=babelek
        END;
      gora:=ostatnio_przestawiony
    END
  END;  {BubbleSort}

PROCEDURE HeapSort(VAR tabl:tablice; dol,gora:typ);
   VAR
    wartosc,i:typ;
   PROCEDURE przesiewanie(i,j:typ);
    VAR
       wartosc,k:typ;
   BEGIN
     k:=2*i;
     WHILE k<=j DO BEGIN
       IF k<j THEN
         IF tabl[k]<tabl[k+1] THEN Inc(k);
       IF tabl[k]>tabl[i] THEN BEGIN
         zamien(tabl[k],tabl[i]);
         i:=k;
         k:=i+i
       END
       ELSE k:=j+1
     END
   END; {przesiewanie}

  BEGIN
    { budowanie stogu }
    i:=(gora-dol+1) DIV 2;
    WHILE i>=dol DO BEGIN
      przesiewanie(i,gora);
      DEC(i)
    END;
    { sortowanie }
    i:=gora;
    WHILE i>dol DO BEGIN
      zamien(tabl[dol],tabl[i]);
      DEC(i);
      przesiewanie(1,i)
    END
  END; {HeapSort}


PROCEDURE InsertionSort(VAR tabl:tablice; dol,gora:typ);
   VAR
      gdzie_wstawic,ktory_wstawic:INTEGER;
      wartosc:typ;
  BEGIN
    ktory_wstawic:=dol+1;
    WHILE ktory_wstawic<=gora DO BEGIN
      wartosc:=tabl[ktory_wstawic];
      gdzie_wstawic:=ktory_wstawic;
      WHILE (gdzie_wstawic>dol) AND
            (wartosc<tabl[gdzie_wstawic-1]) DO BEGIN
        zamien(tabl[gdzie_wstawic],tabl[gdzie_wstawic-1]);
        DEC(gdzie_wstawic)
      END;
      Inc(ktory_wstawic)
    END
  END; { InsertionSort }


PROCEDURE MergeSort(VAR tabl:tablice; dol,gora:typ);
   VAR srodek:INTEGER;
  PROCEDURE scal(poczatek,granica,koniec:INTEGER;
                 VAR tabl:tablice);
     VAR i,j,l:INTEGER;
         z    :tablice;
  BEGIN
     i:=poczatek;  j:=granica;  l:=poczatek;
     WHILE (i<granica) AND (j<=koniec) DO BEGIN
        IF tabl[i]<=tabl[j] THEN
        BEGIN z[l]:=tabl[i];  i:=i+1 END
        ELSE BEGIN z[l]:=tabl[j];  j:=j+1 END;
        l:=l+1
     END;  {WHILE}
     WHILE i<granica DO BEGIN
        z[l]:=tabl[i];
        l:=l+1;  i:=i+1
     END;
     WHILE j<=koniec DO BEGIN
        z[l]:=tabl[j];
        l:=l+1;  j:=j+1
     END;
     FOR i:=poczatek TO koniec DO tabl[i]:=z[i]
  END;  {scal}
 BEGIN
    IF dol<gora THEN BEGIN
       srodek:=(dol+gora) DIV 2;
       MergeSort(tabl,dol,srodek);
       MergeSort(tabl,srodek+1,gora);
       scal(dol,srodek+1,gora,tabl)
    END
 END; {MergeSort}

PROCEDURE QuickSort(VAR tabl:tablice; dol,gora:typ);
   PROCEDURE sort(d,g:typ);
    VAR
       pierwszy,drugi,srodkowy,wartosc:typ;
   BEGIN
     pierwszy:=d;
     drugi:=g;
     srodkowy:=tabl[(d+g) DIV 2];
     REPEAT
       WHILE tabl[pierwszy]<srodkowy DO Inc(pierwszy);
       WHILE srodkowy<tabl[drugi] DO DEC(drugi);
       IF pierwszy<=drugi THEN
       BEGIN
         zamien(tabl[pierwszy],tabl[drugi]);
         Inc(pierwszy);
         DEC(drugi)
       END;
     UNTIL pierwszy>drugi;
     IF d<drugi THEN sort(d,drugi);
     IF pierwszy<g THEN sort(pierwszy,g)
   END; {sort}
  BEGIN {QuickSort}
    sort(dol,gora)
  END;  {QickSort}


PROCEDURE SelectionSort(VAR tabl:tablice; dol,gora:typ);
   VAR
      pierwszy,j,najmniejszy,wartosc:typ;
  BEGIN
    FOR pierwszy:=dol TO gora-1 DO BEGIN
      najmniejszy:=pierwszy;
      wartosc:=tabl[najmniejszy];
      FOR j:=pierwszy+1 TO gora DO
        IF tabl[j]<wartosc THEN BEGIN
          najmniejszy:=j;
          wartosc:=tabl[najmniejszy]
        END;
      zamien(tabl[najmniejszy],tabl[pierwszy])
    END
  END; { SelectionSort }


PROCEDURE ShellSort(VAR tabl:tablice; dol,gora:typ);
   VAR
      ktory_wstawic,gdzie_wstawic:INTEGER;
      krok,wartosc:typ;
  BEGIN
    krok:=1;
    WHILE krok<gora-dol+1 DO krok:=krok+krok;
    WHILE krok>1 DO BEGIN
      krok:=krok DIV 2;
      ktory_wstawic:=dol+krok;
      WHILE ktory_wstawic<=gora DO BEGIN
        wartosc:=tabl[ktory_wstawic];
        gdzie_wstawic:=ktory_wstawic;
        WHILE (gdzie_wstawic-krok>=dol) AND
              (wartosc<tabl[gdzie_wstawic-krok]) DO BEGIN
          zamien(tabl[gdzie_wstawic],tabl[gdzie_wstawic-krok]);
          DEC(gdzie_wstawic,krok)
        END;
        tabl[gdzie_wstawic]:=wartosc;
        Inc(ktory_wstawic)
      END
    END
  END; { ShellSort }

END.