UNIT LISTY;

{  Ten modul zawiera opisy procedur, ktore sa realizacjami algorytmow  de-
monstrowanych w module LISTDATA systemu DISC-MATH w pakiecie EI.
   Krotki opis algorytmow zrealizowanych w tych procedurach  znajduje  sie
w dokumentacji systemu DISC-MATH, a ich szczegolowe omowienie  mozna  zna-
lezc w literaturze przedmiotu zacytowanej w dokumentacji.
   Autorami opisow procedur sa Malgorzata i Slawomir Wlodarczakowie.        }


INTERFACE

TYPE

 T=^re1;                     { listy, listy uporzadkowane i listy cykliczne }
 re1=RECORD
      info : INTEGER;
      nast : T
     END;

 S=^re2;                     { listy dwukierunkowe                          }
 re2=RECORD
            info : INTEGER;
      poprz,nast : S
     END;

 Macierz=^re3;               { macierze rzadkie                             }
 re3=RECORD
      nr_wiersza,nr_kol,wartosc : INTEGER;
           nast_wiersz,nast_kol : Macierz
     END;

 wsk_na_drzewo=^re4;         { drzewa binarne                               }
 re4=RECORD
             war : INTEGER;
      lewe,prawe : wsk_na_drzewo
     END;

VAR

     lista:T;        { Zmienna wskaznikowa oznaczajaca poczatek listy       }

 wartownik:T;        { Zmienna wskazujaca na pusty element na koncu listy,  }
                     { ktorego obecnosc upraszcza wiele operacji.           }
                     { Dla danego programu i listy jest to zmienna globalna }

         i:INTEGER;  { Zmienna numerujaca wezly drzewa binarnego            }

IMPLEMENTATION


 {--------------------- Grupa procedur dotyczacych list --------------------}


PROCEDURE buduj_stos(
     k    :INTEGER;   { liczba elementow, z ktorych ma sie skladac stos     }
 VAR lista:T);        { wskaznik na poczatek stosu                          }

 VAR q:T;             { zmienna robocza tworzaca nowe elementy stosu        }
     i:INTEGER;       { licznik elementow stosu                             }
BEGIN
 lista:=NIL; i:=0;
 WHILE i<k DO BEGIN
  NEW(q); i:=i+1;
  q^.info:=i;
  q^.nast:=lista;
  lista:=q
 END
END;
 {  WYNIK : wskaznik lista na poczatek k-elementowego stosu.                }


PROCEDURE buduj_kolejke(
          k:INTEGER;   { liczba elementow, w kolejce, k>=0                  }
 VAR koniec:T;         { wskaznik na koniec kolejki                         }
 VAR  lista:T);        { wskaznik na poczatek kolejki                       }

 VAR q:T;              { zmienna robocza tworzaca nowe elementy kolejki     }
     i:INTEGER;        { licznik elementow kolejki                          }
BEGIN
 lista:=NIL; koniec:=NIL;
 i:=0;
 WHILE i<k DO BEGIN
  NEW(q); i:=i+1;
  q^.info:=i;
  IF i=1 THEN lista:=q
  ELSE koniec^.nast:=q;
  koniec:=q;
 END;
 IF k>0 THEN koniec^.nast:=NIL
END;
    { WYNIK : wskaznik lista na poczatek k-elementowej kolejki,             }
    {         wskaznik koniec - na koniec kolejki .                         }

PROCEDURE przegladanie(
 lista:T);         { wskaznik na liste, w ktorej pola info elementow        }
                   { zostana zmienione przez zadana operacje                }

 VAR q:T;          { zmienna robocza - umozliwia dostep do kazdego elementu }
BEGIN
 q:=lista;
 WHILE q<>NIL DO BEGIN
  q^.info:=SQR(q^.info);
  q:=q^.nast
 END
END;
 { WYNIK : wskaznik lista na liste o wartosciach pol info bedacych wynikiem }
 {         zadanej operacji.                                                }


PROCEDURE szukaj1(
    x    :INTEGER;    { wartosc pola info szukanego elementu                }
    lista:T;          { wskaznik na liste, w ktorej odbywa sie szukanie     }
VAR     q:T);         { zmienna przeszukujaca liste                         }

 VAR brak:BOOLEAN;    { zmienna logiczna sygnalizujaca znalezienie          }
                      { elementu                                            }
BEGIN
 brak:=TRUE;
 q:=lista;
 WHILE (q<>NIL) AND brak DO
  IF q^.info=x THEN brak:=FALSE
  ELSE q:=q^.nast
END;
 { WYNIK : wskaznik q na znaleziony element. Gdy elementu brak w liscie, to }
 {         wskaznik q ma wartosc NIL.                                       }


PROCEDURE szukaj2(
 x        :INTEGER;   { wartosc pola info szukanego elementu                }
 wartownik,           { wskaznik na ostatni, pusty element listy            }
 lista    :T;         { wskaznik na liste z wartownikiem, w ktorej          }
                      { odbywa sie szukanie                                 }
VAR      q:T);        { wskaznik przeszukujacy liste                        }

BEGIN
 q:=lista; wartownik^.info:=x;
 WHILE q^.info<>x DO
  q:=q^.nast;
 IF q=wartownik THEN
  q:=NIL;
END;
 { WYNIK : wskaznik q na znaleziony element. Gdy elementu brak w liscie, to }
 {         wskaznik q ma wartosc NIL.                                       }


PROCEDURE wstaw_po(
     x,            { wartosc pola info elementu wstawianego                 }
     y    :INTEGER;{ wartosc pola info elementu, po ktorym wstawiamy        }
 VAR p    :T;      { wskaznik sluzacy do utworzenia nowego elementu         }
     lista:T);     { wskaznik na liste, w ktorej wstawiamy nowy element     }

 VAR q:T;          { wskaznik szukajacy elementu, po ktorym wstawiamy       }
BEGIN
 szukaj1(y,q,lista);
 IF q<>NIL THEN BEGIN
  NEW(p); p^.info:=x;
  p^.nast:=q^.nast;
  q^.nast:=p
 END
ELSE p:=NIL
END;
 { WYNIK : lista ze wstawionym nowym elementem i wskaznik p na ten element. }
 {         Gdy nie istnieje element, po ktorym mamy wstawic, lista pozostaje}
 {         nie zmieniona, a wskaznik p ma wartosc NIL.                      }


PROCEDURE wstaw_przed(
     x,            { wartosc pola info elementu wstawianego                 }
     y    :INTEGER;{ wartosc pola info elementu, przed ktorym wstawiamy     }
 VAR p    :T;      { wskaznik sluzacy do utworzenia nowego elementu         }
     lista:T);     { wskaznik na liste z wartownikiem, w ktorej wstawiamy   }
                   { nowy element                                           }
 VAR q    :T;      { wskazniki przeszukujace liste metoda jeden za drugim   }
BEGIN
 p:=lista; wartownik^.info:=y;
 REPEAT q:=p; p:=q^.nast
 UNTIL p^.info=y;
 IF p<>wartownik THEN BEGIN
  NEW(p); p^.info:=x;
  p^.nast:=q^.nast;
  q^.nast:=p
 END
 ELSE p:=NIL
END;
 { WYNIK : lista ze wstawionym nowym elementem i wskaznik p na ten element. }
 {         Gdy nie istnieje element, przed ktorym wstawiamy, lista pozostaje}
 {         nie zmieniona, a wskaznik p ma wartosc NIL.                      }


PROCEDURE usun_po(
     y    :INTEGER;{ wartosc pola info elementu, po ktorym usuwamy          }
 VAR p    :T;      { wskaznik, ktory bedzie wskazywal na element usuniety   }
     lista:T);     { wskaznik na liste, z ktorej usuwamy element            }

 VAR q:T;          { wskaznik szukajacy elementu, po ktorym usuwamy         }
BEGIN
 szukaj1(y,q,lista);
 IF (q<>NIL) AND (q^.nast<>NIL) THEN
 BEGIN
  p:=q^.nast;
  q^.nast:=p^.nast;
  p^.nast:=NIL
 END ELSE p:=NIL
END;
 { WYNIK : lista pozbawiona elementu po zadanym i wskaznik p na usuniety    }
 {         element. Jesli nie istnial element, po ktorym nalezalo usunac    }
 {         lub byl on ostatni, lista pozostaje nie zmieniona, a wskaznik    }
 {         p ma wartosc NIL.                                                }


PROCEDURE usun_dany(
     y    :INTEGER;{ wartosc pola info elementu, ktory usuwamy              }
 VAR p    :T;      { wskaznik, ktory bedzie wskazywal na element usuniety   }
     lista:T);     { wskaznik na liste z wartownikiem, z ktorej element     }
                   { ma zostac usuniety                                     }

 VAR q:T;          { wskaznik, ktory razem ze wskaznikiem p bedzie          }
                   { przeszukiwal liste metoda jeden za drugim              }
BEGIN
 p:=lista; wartownik^.info:=y;
 REPEAT q:=p; p:=q^.nast
 UNTIL p^.info=y;
 IF p<>wartownik THEN BEGIN
  q^.nast:=p^.nast;
  p^.nast:=NIL
 END ELSE p:=NIL
END;
 { WYNIK : lista pozbawiona zadanego elementu i wskaznik p na usuniety      }
 {         element. Jesli nie istnial element, ktory nalezalo usunac        }
 {         to p ma wartosc NIL.                                             }


 {--------------Grupa procedur dotyczacych list uporzadkowanych-------------}


PROCEDURE szukaj(
     x      :INTEGER;{ wartosc pola info elementu, ktorego szukamy          }
 VAR p,q    :T;      { wskazniki przeszukujace liste metoda jeden za drugim }
     lista  :T);     { wskaznik na liste uporzadkowana z wartownikiem, w    }
                     { ktorej szukamy                                       }
BEGIN
 q:=lista; wartownik^.info:=x;
 p:=q^.nast;
 WHILE p^.info<x DO BEGIN
  q:=p; p:=q^.nast;
 END
END;
  { WYNIK : wskaznik p na pierwszy taki element, ktorego wartosc pola info  }
  {         jest wieksza lub rowna x. Wskaznik q wskazuje na poprzednika.   }


PROCEDURE wstaw(
   x    :INTEGER;  { wartosc pola info elementu wstawianego                 }
   lista:T);       { wskaznik na liste uporzadkowana z wartownikiem, do     }
                   { ktorej wstawiamy                                       }

 VAR p,q:T;        { wskazniki przeszukujace liste metoda jeden za drugim   }
BEGIN
 szukaj(x,p,q,lista);
 NEW(p); p^.info:=x;
 p^.nast:=q^.nast;
 q^.nast:=p
END;
  { WYNIK : lista z nowym elementem wstawionym przed elementem znalezionym  }
  {         za pomoca procedury szukaj.                                     }


PROCEDURE usun(
   x    :INTEGER;  { wartosc pola info elementu usuwanego                   }
   lista:T);       { wskaznik na uporzadkowana liste z wartownikiem, z      }
                   { ktorej usuwamy                                         }
 VAR p,q:T;        { wskazniki przeszukujace liste metoda jeden za drugim   }
BEGIN
 szukaj(x,p,q,lista);
 IF (p<>wartownik) AND (p^.info=x) THEN
 BEGIN
  q^.nast:=p^.nast;
  p^.nast:=NIL
 END
END;
   { WYNIK : lista pozbawiona zadanego elementu, jesli zostal on znaleziony }
   {         (za pomoca procedury szukaj) i nie byl wartownikiem.           }


 {----------------Grupa procedur dotyczacych list cyklicznych---------------}


PROCEDURE przeglad(
 lista:T);       { wskaznik na liste cykliczna                              }

 VAR p:T;        { zmienna robocza, umozliwia dostep do kazdego elementu    }
BEGIN
 IF lista<>NIL THEN BEGIN
  p:=lista^.nast;
  REPEAT
   p^.info:=p^.info+1;
   p:=p^.nast
  UNTIL p=lista^.nast
 END
END;
 { WYNIK : wskaznik lista na liste cykliczna o wartosciach pol info bedacych}
 {         wynikiem zadanej operacji.                                       }


PROCEDURE usun_nast(
     p:T;            { wskaznik na element, po ktorym nalezy usunac         }
 VAR x:INTEGER);     { zmienna, ktora zapamieta wartosc pola info           }
                     { usuwanego elementu                                   }

 VAR q:T;            { zmienna robocza, umozliwiajaca usuniecie elementu    }
BEGIN
 IF (p<>NIL) AND (p<>p^.nast) THEN
 BEGIN
  q:=p^.nast;
  x:=q^.info;
  p^.nast:=q^.nast;
  DISPOSE(q)
 END
END;
 { WYNIK : lista pozbawiona zadanego elementu, jesli nie byla pusta, lub    }
 {         nie skladala sie z jednego elementu.                             }


PROCEDURE polacz(
 VAR list1,list2:T);    { listy cykliczne, ktore nalezy polaczyc            }

 VAR p:T;               { wskaznik roboczy                                  }
BEGIN
 IF list1=NIL THEN list1:=list2
 ELSE IF list2<>NIL THEN BEGIN
  p:=list1^.nast;
  list1^.nast:=list2^.nast;
  list2^.nast:=p;
  list1:=list2
 END
END;
 { WYNIK : wskaznik list1 wskazuje na liste cykliczna, bedaca wynikiem      }
 {         polaczenia dwoch list cyklicznych.                               }


 {-------Grupa procedur dotyczacych list dwukierunkowych cyklicznych--------}


PROCEDURE znajdz_poprz(
     x    :INTEGER;    { wartosc pola info elementu, dla ktorego nalezy     }
                       { znalezc poprzednika                                }
     lista:S;          { wskaznik na liste, w ktorej szukamy                }
 VAR p    :S);         { wskaznik przeszukujacy                             }

BEGIN
 p:=lista;
 IF lista<>NIL THEN BEGIN
  REPEAT p:=p^.nast
  UNTIL (p^.info=x) OR (p=lista);
  IF p^.info=x THEN
   p:=p^.poprz
  ELSE p:=NIL
 END
END;
  { WYNIK : gdy zadany element istnieje, to wskaznik p wskazuje na jego     }
  {         poprzednika. Jesli nie, to wskaznik p ma wartosc NIL.           }


PROCEDURE usun_ldc(
     p    :S;         { wskaznik na element, ktory nalezy usunac z listy    }
 VAR lista:S;         { wskaznik na dana liste                              }
 VAR x    :INTEGER);  { zmienna, ktora zapamieta wartosc pola info          }
                      { usuwanego elementu                                  }

 VAR   r,q:S;         { wskazniki robocze                                   }
BEGIN
 IF p<>NIL THEN BEGIN
   x:=p^.info;
  IF p=p^.nast THEN lista:=NIL ELSE
  BEGIN
   q:=p^.poprz;
   r:=p^.nast;
   q^.nast:=r;
   r^.poprz:=q
  END
 END
END;
 { WYNIK : lista dwukierunkowa cykliczna pozbawiona zadanego elementu;      }
 {         zmienna x zawiera wartosc usunietego elementu.                   }


PROCEDURE wstaw_nast(
 p:S;           { wskaznik na element, po ktorym wstawiamy                  }
 x:INTEGER);    { wartosc pola info wstawianego elementu                    }

 VAR r,q:S;     { wskazniki robocze                                         }
BEGIN
 IF p<>NIL THEN BEGIN
  NEW(q);
  q^.info:=x;
  r:=p^.nast;
  r^.poprz:=q;
  q^.nast:=r;
  q^.poprz:=p;
  p^.nast:=q
 END
END;
 { WYNIK : lista dwukierunkowa cykliczna z wstawionym nowym elementem.      }


PROCEDURE wiersz_SQR(
 p:macierz;           { wskaznik na liste reprezentujaca macierz            }
 i:INTEGER);          { numer wiersza, w ktorym nalezy wykonac operacje     }

BEGIN
 IF (i>0) AND (i<=4) THEN BEGIN
  WHILE p^.nr_wiersza<>i DO
   p:=p^.nast_wiersz;
  p:=p^.nast_kol;
  WHILE p^.nr_kol<>0 DO BEGIN
   p^.wartosc:=SQR(p^.wartosc);
   p:=p^.nast_kol
  END
 END
END;
  { WYNIK : wskaznik na liste reprezentujaca macierz rzadka, w ktorej       }
  {         wartosci danego wiersza sa podniesione do kwadratu              }


 {----------------Grupa procedur dotyczacych drzew binarnych----------------}


PROCEDURE preorder(
 p:wsk_na_drzewo);     { wskaznik na zadane drzewo                          }

BEGIN
 IF p<>NIL THEN BEGIN
  i:=i+1; p^.war:=i;
  preorder(p^.lewe);
  preorder(p^.prawe)
 END
END;
 { WYNIK : drzewo przegladniete w porzadku preorder. Pola info elementow    }
 {         drzewa sa ponumerowane w kolejnosci odwiedzania (jest to         }
 {         przykladowa operacja).                                           }


PROCEDURE inorder(
 p:wsk_na_drzewo);     { wskaznik na zadane drzewo                          }

BEGIN
 IF p<>NIL THEN BEGIN
  inorder(p^.lewe);
  i:=i+1; p^.war:=i;
  inorder(p^.prawe)
 END
END;
  { WYNIK : drzewo przegladniete w porzadku inorder. Pola info elementow    }
  {         drzewa sa ponumerowane w kolejnosci odwiedzania (jest to        }
  {         przykladowa operacja).                                          }


PROCEDURE postorder(
 p:wsk_na_drzewo);     { wskaznik na zadane drzewo                          }

BEGIN
 IF p<>NIL THEN BEGIN
  postorder(p^.lewe);
  postorder(p^.prawe);
  i:=i+1; p^.war:=i
 END
END;
 { WYNIK : drzewo przegladniete w porzadku postorder. Pola info elementow   }
 {         drzewa sa ponumerowane w kolejnosci odwiedzania (jest to         }
 {         przykladowa operacja).                                           }


PROCEDURE wyr_algeb(
 p:wsk_na_drzewo);      { wskaznik na drzewo, ktore reprezentuje wyrazenie  }
                        { algebraiczne.                                     }
BEGIN
 IF p<>NIL THEN BEGIN
  wyr_algeb(p^.lewe);
  wyr_algeb(p^.prawe);
  WRITE(p^.war)
 END
END;
  { WYNIK : wyrazenie wydrukowane w odwrotnej notacji polskiej              }

END. {LISTY}

