UNIT GRAPHPRO;

{  Ten modul zawiera opisy procedur, ktore sa realizacjami algorytmow  de-
monstrowanych w module GRAPHALG systemu DISC-MATH w pakiecie EI.  Ponadto,
zamieszczono definicje struktur danych wystepujacych w tych procedurach.
   Krotki opis algorytmow zrealizowanych w tych procedurach  znajduje  sie
w dokumentacji systemu DISC-MATH, a ich szczegolowe omowienie  mozna  zna-
lezc w literaturze przedmiotu zacytowanej w dokumentacji.
   Autorem opisow procedur jest Maciej M. Syslo.  }

INTERFACE

CONST
   NMAX=50;
   MMAX=5000;

TYPE
   VERTPOINT=^VERTLIST;
   VERTLIST =RECORD
                VERTEX:INTEGER;
                WEIGHT:INTEGER;
                NEXT  :VERTPOINT
             END;
   GRAPH    =ARRAY[1..NMAX] OF
                RECORD
                   IN_DEG,OUT_DEG          :INTEGER;
                   VERTEX                  :INTEGER;
                   IN_ADJ_LIST,OUT_ADJ_LIST:VERTPOINT
                END;

   LIST     =^ELEM;
   LTREE    =^NODE;
   ELEM     =RECORD
                F,B :LIST;
                TREE:LTREE
             END;
   NODE     =RECORD
                V1,V2,KEY:INTEGER;
                RANK     :INTEGER;
                DEL      :BOOLEAN;
                L,R,MATCH:LTREE
             END;
   ARRL     =ARRAY[1..NMAX] OF LIST;
   ARRM     =ARRAY[1..MMAX] OF INTEGER;
   ARRN     =ARRAY[1..NMAX] OF INTEGER;
   ARRN1    =ARRAY[1..NMAX-1] OF INTEGER;
   ARRPN    =ARRAY[1..NMAX] OF VERTPOINT;
   ARRNN    =ARRAY[1..NMAX,1..NMAX] OF INTEGER;
   ARRBN    =ARRAY[1..NMAX] OF BOOLEAN;


PROCEDURE DFS(
       N,S :INTEGER;
   VAR DIG :GRAPH;
   VAR PRED:ARRN);

PROCEDURE BFS(
       N,S :INTEGER;
   VAR DIG :GRAPH;
   VAR PRED:ARRN);

PROCEDURE PDM(
       N,M,S,INF:INTEGER;
   VAR POINTER  :ARRN1;
   VAR ENDV,WT  :ARRM;
   VAR DIST,PRED:ARRN);

PROCEDURE DIJKSTRA(
       N,INF,S,T:INTEGER;
   VAR W        :ARRNN;
   VAR PATH     :BOOLEAN;
   VAR FINAL    :ARRBN;
   VAR DIST,PRED:ARRN);

PROCEDURE CPM(
       N,INF    :INTEGER;
   VAR DIG      :GRAPH;
   VAR ACYCLIC  :BOOLEAN;
   VAR DIST,PRED:ARRN);

PROCEDURE KRUSKAL(
       N,M               :INTEGER;
   VAR ENDV1,ENDV2,WEIGHT:ARRM;
   VAR CONNECT           :BOOLEAN;
   VAR TEDGE1,TEDGE2     :ARRN1;
   VAR TWEIGHT           :INTEGER);

PROCEDURE PRIM(
       N,INF        :INTEGER;
   VAR W            :ARRNN;
   VAR CONNECT      :BOOLEAN;
   VAR TEDGE1,TEDGE2:ARRN1;
   VAR TWEIGHT      :INTEGER);

PROCEDURE SOLIN(
       N,M,INF           :INTEGER;
   VAR ENDV1,ENDV2,WEIGHT:ARRM;
   VAR TEDGE1,TEDGE2     :ARRN1;
   VAR TCOUNT,TWEIGHT    :INTEGER);


IMPLEMENTATION


PROCEDURE DFS(
       N,S :INTEGER;
   VAR DIG :GRAPH;
   VAR PRED:ARRN);

{  Procedura DFS przeszukuje metoda dfs N-wierzcholkowy digraf DIG, dany w
 postaci tablicy list. Przeszukiwanie rozpoczyna sie w wierzcholku S.
   Drzewo osiagalnosci wierzcholkow z wierzcholka S jest zapisane w tabli-
 cy PRED, zawierajacej poprzedniki wierzcholkow wzgledem zrodla S.  }

 VAR VER:INTEGER;
     LAB:ARRBN;

 PROCEDURE DEPTH(I:INTEGER);
    VAR J:INTEGER;
        P:VERTPOINT;
 BEGIN
    LAB[I]:=FALSE;
    P:=DIG[I].OUT_ADJ_LIST;
    WHILE P <> NIL DO BEGIN
       J:=P^.VERTEX;
       IF LAB[J] THEN BEGIN
          PRED[J]:=I;
          DEPTH(J)
       END;
       P:=P^.NEXT
    END { WHILE }
 END { DEPTH };

BEGIN
   FOR VER:=1 TO N DO BEGIN
      PRED[VER]:=-1;  LAB[VER]:=TRUE
   END;
   PRED[S]:=0;
   DEPTH(S)
END { DFS };

PROCEDURE BFS(
       N,S :INTEGER;
   VAR DIG :GRAPH;
   VAR PRED:ARRN);

{  Procedura BFS przeszukuje metoda bfs N-wierzcholkowy digraf DIG, dany w
 postaci tablicy list. Przeszukiwanie rozpoczyna sie w wierzcholku S.
   Drzewo osiagalnosci wierzcholkow z wierzcholka S jest zapisane w tabli-
 licy PRED, zawierajacej poprzedniki wierzcholkow wzgledem zrodla S.  }

 TYPE LIST=^ELEM;
      ELEM=RECORD
              VERT:INTEGER;
              NEXT:LIST
           END;
 VAR R,T,VER:INTEGER;
     Q,Q_END:LIST;
     P      :VERTPOINT;
     LAB    :ARRBN;

  FUNCTION EMPTY_Q:BOOLEAN;
  BEGIN
     EMPTY_Q:=Q=NIL
  END; { EMPTY_Q }

  PROCEDURE ADD_TO_Q(I:INTEGER);
     VAR EL:LIST;
  BEGIN
     NEW(EL);
     EL^.VERT:=I;
     IF EMPTY_Q THEN Q:=EL
     ELSE Q_END^.NEXT:=EL;
     Q_END:=EL
  END; { ADD_TO_Q }

  FUNCTION TAKE_FROM_Q:INTEGER;
  BEGIN
     TAKE_FROM_Q:=Q^.VERT;
     IF Q=Q_END THEN Q:=NIL
     ELSE Q:=Q^.NEXT
  END; { TAKE_FROM_Q }

BEGIN
   FOR VER:=1 TO N DO BEGIN
      PRED[VER]:=-1;  LAB[VER]:=TRUE
   END;
   PRED[S]:=0;  LAB[S]:=FALSE;
   Q:=NIL;
   ADD_TO_Q(S);
   WHILE NOT EMPTY_Q DO BEGIN
      R:=TAKE_FROM_Q;
      P:=DIG[R].OUT_ADJ_LIST;
      WHILE P <> NIL DO BEGIN
         T:=P^.VERTEX;
         IF LAB[T] THEN BEGIN
            LAB[T]:=FALSE;
            PRED[T]:=R;
            ADD_TO_Q(T)
         END; { NEW VERTEX REACHED }
         P:=P^.NEXT
      END { SEARCH OF R NEIGHBOURS }
   END
END { BFS };

PROCEDURE PDM(
       N,M,S,INF:INTEGER;
   VAR POINTER  :ARRN1;
   VAR ENDV,WT  :ARRM;
   VAR DIST,PRED:ARRN);

{  Procedura PDM wyznacza najkrotsze drogi ze zrodla S do wszystkich wierz-
 cholkow w sieci skladajacej sie z N wierzcholkow i M lukow. Siec jest da-
 na za pomoca tablic POINTER, ENDV i WT, stanowiacych tablicowa  reprezen-
 tacje jej pekow wyjsciowych. (INF powinna byc duza liczba naturalna.)
   Siec nie moze zawierac cykli ujemnej dlugosci.
   Dlugosci znalezionych najkrotszych drog sa zapisane w  tablicy  DIST, a
 wierzcholki poprzedzajace na najkrotszych drogach z S - w tablicy PRED.
   Procedura PDM jest realizacja algorytmu Bellmana-Forda, w wersji  poda-
 nej przez Moore'a, d'Esopo i Papego.    }

   VAR U,V,J,HEAD,FIRST,LAST,NEXT,NEWLABEL,TEMP:INTEGER;
       QUEUE                                   :ARRN;
BEGIN
   FOR V:=1 TO N DO BEGIN
      DIST[V]:=INF;            { INF = WEIGHT OF A NONEXISTING EDGE }
      PRED[V]:=-1;  QUEUE[V]:=-1
   END;
   DIST[S]:=0;  HEAD:=S;  U:=S;
   QUEUE[HEAD]:=INF;                          { INITIALIZATION OVER }
   WHILE U <> INF DO BEGIN
      NEXT:=QUEUE[U];  QUEUE[U]:=0;
      FIRST:=POINTER[U];  LAST:=POINTER[U+1]-1;
      FOR J:=FIRST TO LAST DO BEGIN
         V:=ENDV[J];
         NEWLABEL:=DIST[U]+WT[J];
         IF DIST[V] > NEWLABEL THEN BEGIN            { CHANGE LABEL }
            PRED[V]:=U;  DIST[V]:=NEWLABEL;
            TEMP:=NEXT;
            IF QUEUE[V] < 0 THEN BEGIN
               QUEUE[HEAD]:=V;  HEAD:=V;  QUEUE[HEAD]:=INF;
               IF TEMP = INF THEN TEMP:=V;
               NEXT:=TEMP
            END
            ELSE
               IF QUEUE[V] = 0 THEN BEGIN
                  QUEUE[V]:=TEMP;  NEXT:=V
               END
               ELSE  NEXT:=TEMP
         END { IF DIST[V] > NEWLABEL }
      END;  { FOR J }
      U:=NEXT
   END  { WHILE U <> INF }
END;  { PDM }

PROCEDURE DIJKSTRA(
       N,INF,S,T:INTEGER;
   VAR W        :ARRNN;
   VAR PATH     :BOOLEAN;
   VAR FINAL    :ARRBN;
   VAR DIST,PRED:ARRN);

{  Procedura DIJKSTRA jest realizacja algorytmu Dijkstry i  wyznacza  naj-
 krotsza droge ze zrodla S do odplywu T w sieci N-wierzcholkowaj danej  za
 pomoca macierzy wag W, w ktorej INF jest  wartoscia nieistniejacego luku.
 Dlugosci lukow w sieci musza byc nieujemne.
   Dlugosci znalezionych najkrotszych drog sa zapisane w  tablicy  DIST, a
 wierzcholki poprzedzajace na najkrotszych drogach z S - w tablicy PRED.
   Zmienne logiczne PATH i FINAL okreslaja czy istnieje droga z S  do  in-
 nych wierzcholkow i czy znaleziono najkrotsza.   }

   VAR U,V,Y,RECENT,NEWLABEL,TEMP:INTEGER;
BEGIN
   FOR V:=1 TO N DO BEGIN
      DIST[V]:=INF;  FINAL[V]:=FALSE;  PRED[V]:=-1
   END;                       { INF = WEIGHT OF A  NONEXISTENT EDGE }
   DIST[S]:=0;  FINAL[S]:=TRUE;
   PATH:=TRUE;  RECENT:=S;                    { INITIALIZATION OVER }
   WHILE NOT FINAL[T] DO BEGIN
      FOR V:=1 TO N DO                             { FIND NEW LABEL }
         IF (W[RECENT,V] < INF) AND (NOT FINAL[V]) THEN BEGIN
            NEWLABEL:=DIST[RECENT]+W[RECENT,V];
            IF NEWLABEL < DIST[V] THEN BEGIN
               DIST[V]:=NEWLABEL;  PRED[V]:=RECENT
            END
         END;
      TEMP:=INF;
      FOR U:=1 TO N DO               { FIND SMALLEST LABELED VERTEX }
         IF (NOT FINAL[U]) AND (DIST[U] < TEMP) THEN  BEGIN
            Y:=U;  TEMP:=DIST[U]
         END;
      IF TEMP < INF THEN BEGIN                    { THERE IS A PATH }
         FINAL[Y]:=TRUE;  RECENT:=Y
      END
      ELSE BEGIN                     { THERE IS NO PATH FROM S TO T }
         PATH:=FALSE;  FINAL[T]:=TRUE
      END
   END  { WHILE NOT FINAL[T] }
END;  { DIJKSTRA }

PROCEDURE CPM(
       N,INF    :INTEGER;
   VAR DIG      :GRAPH;
   VAR ACYCLIC  :BOOLEAN;
   VAR DIST,PRED:ARRN);

{  Procedura CPM wyznacza najkrotsze drogi ze zrodel do  wszystkich  pozos-
 talych wierzcholkow w N-wierzcholkowej sieci acyklicznej DIG, danej w pos-
 taci list sasiadow. Zmienna logiczna ACYCLIC przyjmuje wartosc TRUE, jesli
 siec nie zawiera cyklu i FALSE - w przeciwnym razie. W tym drugim przypad-
 ku, obliczenia zostaja przerwane.
   Dlugosci znalezionych najkrotszych drog sa zapisane w  tablicy  DIST, a
 wierzcholki poprzedzajace na najkrotszych drogach - w tablicy PRED.  }


   FUNCTION TOPOLOGICAL_SORT(
          N                    :INTEGER;
      VAR DIG                  :GRAPH;
      VAR TOP_SORT,REV_TOP_SORT:ARRN):BOOLEAN;

   VAR
      I,J,K,KK,L:INTEGER;
      CYCLE     :BOOLEAN;
      P         :VERTPOINT;
      A         :ARRN;
   BEGIN
      FOR I:=1 TO N DO A[I]:=DIG[I].IN_DEG;
      K:=0; L:=0;
      FOR I:=1 TO N DO
         IF A[I] = 0 THEN BEGIN
            K:=K+1;
            TOP_SORT[K]:=I;
            REV_TOP_SORT[I]:=K
         END; {I}
      CYCLE:=K > 0;
      WHILE (K < N) AND CYCLE DO BEGIN
         KK:=K;
         FOR J:=L+1 TO KK DO BEGIN
            P:=DIG[TOP_SORT[J]].OUT_ADJ_LIST;
            WHILE P <> NIL DO BEGIN
               I:=P^.VERTEX;
               A[I]:=A[I]-1;
               IF A[I] = 0 THEN BEGIN
                  K:=K+1;
                  TOP_SORT[K]:=I;
                  REV_TOP_SORT[I]:=K
               END; {NEW SOURCE}
               P:=P^.NEXT
            END {WHILE}
         END; {FOR J}
         L:=KK;
         CYCLE:=K <> KK
      END; {WHILE}
      TOPOLOGICAL_SORT:=CYCLE
   END; {TOPOLOGICAL_SORT}

VAR I,J,K,R,T,U:INTEGER;
    P          :VERTPOINT;
    ORD,REV_ORD:ARRN;

BEGIN
   ACYCLIC:=TOPOLOGICAL_SORT(N,DIG,ORD,REV_ORD);
   IF ACYCLIC THEN BEGIN
      K:=0;
      REPEAT
         K:=K+1;
         DIST[ORD[K]]:=0;  PRED[ORD[K]]:=0
      UNTIL DIG[ORD[K+1]].IN_DEG > 0;
      FOR I:=K+1 TO N DO DIST[ORD[I]]:=INF;
      FOR I:=K+1 TO N DO BEGIN
         J:=ORD[I];
         P:=DIG[J].IN_ADJ_LIST;
         IF P <> NIL THEN BEGIN
            R:=INF;
            WHILE P <> NIL DO BEGIN
               T:=DIST[P^.VERTEX]+P^.WEIGHT;
               IF T < R THEN BEGIN
                  R:=T;   U:=P^.VERTEX
               END;
               P:=P^.NEXT
            END; {WHILE}
            DIST[J]:=R;
            PRED[J]:=U
         END {IF}
         ELSE PRED[J]:=-1
      END {I}
   END {ACYCLIC}
END; { CPM }

PROCEDURE KRUSKAL(
       N,M               :INTEGER;
   VAR ENDV1,ENDV2,WEIGHT:ARRM;
   VAR CONNECT           :BOOLEAN;
   VAR TEDGE1,TEDGE2     :ARRN1;
   VAR TWEIGHT           :INTEGER);

{   Procedura KRUSKAL jest realizacja zachlannego algorytmu Kruskala i wyz-
 nacza najkrotsze drzewo rozpinajace w sieci zawierajacej  N  wierzcholkow
 i M krawedzi. Siec jest dana za pomoca dwoch tablic ENDV1 i ENDV2  zawie-
 rajacych numery koncow krawedzi i tablicy WEIGHT - zawierajacej wagi kra-
 wedzi.
    Konce krawedzi znalezionego drzewa sa pamietane w  tablicach  TEDGE1 i
 TEDGE2, a jego waga wynosi TWEIGHT. Zmienna logiczna CONNECT okresla, czy
 znalezione rozwiazanie jest spojne (gdyz rozpatrywana siec nie  musi  byc
 spojna).   }

   VAR I,LAST,U,V,R1,R2,ECOUNT,TCOUNT:INTEGER;
       FATHER                        :ARRN;

   PROCEDURE HEAP(FIRST,LAST:INTEGER);
      VAR J,K,TEMP1,TEMP2,TEMP3:INTEGER;
   BEGIN
      J:=FIRST;
      WHILE J <= TRUNC(LAST/2) DO BEGIN
         IF (2*J < LAST) AND (WEIGHT[2*J+1] < WEIGHT[2*J]) THEN
            K:=2*J+1
         ELSE K:=2*J;
         IF WEIGHT[K] < WEIGHT[J] THEN BEGIN
            TEMP1:=ENDV1[J];  TEMP2:=ENDV2[J];  TEMP3:=WEIGHT[J];
            ENDV1[J]:=ENDV1[K];  ENDV2[J]:=ENDV2[K];
            WEIGHT[J]:=WEIGHT[K];
            ENDV1[K]:=TEMP1;  ENDV2[K]:=TEMP2;
            WEIGHT[K]:=TEMP3;
            J:=K
         END  { IF WEIGHT[K] < WEIGHT[J] }
         ELSE J:=LAST
      END  { WHILE J <= TRUNC(LAST/2) }
   END;  { HEAP }

   FUNCTION FIND(I:INTEGER):INTEGER;
      VAR PTR:INTEGER;
   BEGIN
      PTR:=I;
      WHILE FATHER[PTR] > 0 DO PTR:= FATHER[PTR];
      FIND:=PTR
   END;  { FIND }

   PROCEDURE UNION(I,J:INTEGER);
      VAR X:INTEGER;
   BEGIN
      X:=FATHER[I]+FATHER[J];
      IF FATHER[I] > FATHER[J] THEN BEGIN
         FATHER[I]:=J;  FATHER[J]:=X
      END
      ELSE BEGIN
         FATHER[J]:=I;  FATHER[I]:=X
      END
   END;  { UNION }

BEGIN                                                   { MAIN BODY }
   FOR I:=1 TO N DO FATHER[I]:=-1;
   FOR I:=TRUNC(M/2) DOWNTO 1 DO                     { INITIAL HEAP }
      HEAP(I,M);
   LAST:=M;
   ECOUNT:=0;  TCOUNT:=0;
   TWEIGHT:=0;  CONNECT:=TRUE;                { INITIALIZATION OVER }
   WHILE ((TCOUNT < N-1) AND (ECOUNT < M)) DO BEGIN
      ECOUNT:=ECOUNT+1;
      U:=ENDV1[1];  V:=ENDV2[1];
      R1:=FIND(U);  R2:=FIND(V);
      IF R1 <> R2 THEN BEGIN                 { INCLUDE (U,V) IN MST }
         TCOUNT:=TCOUNT+1;  UNION(R1,R2);
         TEDGE1[TCOUNT]:=U;  TEDGE2[TCOUNT]:=V;
         TWEIGHT:=TWEIGHT+WEIGHT[1]
      END;  { IF R1 <> R2 }
      ENDV1[1]:=ENDV1[LAST];  ENDV2[1]:=ENDV2[LAST];
      WEIGHT[1]:=WEIGHT[LAST];
      LAST:=LAST-1;
      HEAP(1,LAST)
   END;  { WHILE ((TCOUNT < N-1) ... - ITERATION }
   IF TCOUNT <> N-1 THEN CONNECT:=FALSE
END;  { KRUSKAL }

PROCEDURE PRIM(
       N,INF        :INTEGER;
   VAR W            :ARRNN;
   VAR CONNECT      :BOOLEAN;
   VAR TEDGE1,TEDGE2:ARRN1;
   VAR TWEIGHT      :INTEGER);

{   Procedura PRIM jest realizacja algorytmu Prima-Dijkstry i wyznacza naj-
 krotsze drzewo rozpinajace w sieci N-wierzcholkowej danej za pomoca macie-
 rzy wag W, w ktorej nieistniejaca krawedz ma wage INF.
    Konce krawedzi znalezionego drzewa sa pamietane w  tablicach  TEDGE1 i
 TEDGE2, a jego waga wynosi TWEIGHT. Zmienna logiczna CONNECT okresla, czy
 znalezione rozwiazanie jest spojne (gdyz rozpatrywana siec nie  musi  byc
 spojna).   }

   VAR U,I,K,MIN,TCOUNT:INTEGER;
       NEAR,DIST       :ARRN;
BEGIN
   NEAR[1]:=0;
   FOR I:=2 TO N DO BEGIN
      NEAR[I]:=1;  DIST[I]:=W[1,I]
   END;
   TCOUNT:=0;  TWEIGHT:=0;
   CONNECT:=TRUE;                             { INITIALIZATION OVER }
   WHILE (TCOUNT < N-1) AND CONNECT  DO BEGIN
      MIN:=INF;
      FOR K:=2 TO N DO
         IF NEAR[K] <> 0 THEN
            IF DIST[K] < MIN THEN BEGIN
               U:=K;  MIN:=DIST[K]
            END;
      IF DIST[U] >= INF THEN CONNECT:=FALSE
      ELSE BEGIN
         TCOUNT:=TCOUNT+1;  TWEIGHT:=TWEIGHT+DIST[U];
         TEDGE1[TCOUNT]:=NEAR[U];  TEDGE2[TCOUNT]:=U;
         NEAR[U]:=0;
         FOR K:=2 TO N DO
            IF NEAR[K] <> 0 THEN
               IF W[K,NEAR[K]] > W[K,U] THEN BEGIN
                  DIST[K]:=W[K,U]; NEAR[K]:=U
               END
      END  { ELSE: NOT (DIST[U] >= INF) }
   END  { WHILE (TCOUNT < N-1) ... }
END;  { PRIM }

PROCEDURE SOLIN(
       N,M,INF           :INTEGER;
   VAR ENDV1,ENDV2,WEIGHT:ARRM;
   VAR TEDGE1,TEDGE2     :ARRN1;
   VAR TCOUNT,TWEIGHT    :INTEGER);

{   Procedura SOLIN jest realizacja zachlannego algorytmu Solina i  wyzna-
 cza najkrotsze drzewo rozpinajace w sieci zawierajacej  N  wierzcholkow i
 M krawedzi. Siec jest dana za pomoca dwoch tablic ENDV1 i ENDV2  zawiera-
 jacych numery koncow krawedzi i tablicy WEIGHT - z wagami krawedzi.
    Konce krawedzi znalezionego drzewa sa pamietane w  tablicach  TEDGE1 i
 TEDGE2, a jego waga wynosi TWEIGHT. Zmienna TCOUNT okresla liczbe  krawe-
 dzi w znalezionym rozwiazaniu, ktora jest rowna N-1 jesli rozwiazanie jest
 spojne lub jest mniejsza od N-1, w przeciwnym przypadku.  }

VAR I,J,K,V,W :INTEGER;
    HH,LT1,LT2:LTREE;
    P,Q,QB,QE :LIST;
    FATHER    :ARRN;
    H         :ARRL;

PROCEDURE MELD(H1,H2:LTREE;VAR H:LTREE);
   VAR HH:LTREE;
BEGIN
   IF H1=NIL THEN H:=H2
   ELSE IF H2=NIL THEN H:=H1
        ELSE BEGIN
           IF H1^.KEY > H2^.KEY THEN BEGIN
              HH:=H1;  H1:=H2;  H2:=HH
           END;
           IF H1^.R=NIL THEN H1^.R:=H2
           ELSE MELD(H1^.R,H2,H1^.R);
           IF H1^.L^.RANK < H1^.R^.RANK THEN BEGIN
              HH:=H1^.L;  H1^.L:=H1^.R;  H1^.R:=H1^.L
           END;
           H1^.RANK:=H1^.R^.RANK+1;
           H:=H1
        END
END; {MELD}

PROCEDURE L_MELD(T1,T2:LTREE;VAR TT:LTREE);
   VAR LT,T12:LTREE;
BEGIN
   IF T1=NIL THEN TT:=T2
   ELSE IF T2=NIL THEN TT:=T1
        ELSE BEGIN
           NEW(LT);
           IF T1^.RANK <T2^.RANK THEN BEGIN
              T12:=T1;  T1:=T2;  T2:=T12  END;
           WITH LT^ DO BEGIN
              L:=T1;  R:=T2;  KEY:=-INF;  RANK:=T2^.RANK+1;
              DEL:=TRUE
           END;
           TT:=LT
        END
END; {L_MELD}

PROCEDURE FIND_MIN(VAR T:LTREE);
   VAR LB,LE:LIST;
   PROCEDURE HEAPIFY(VAR LB,LE:LIST;VAR T:LTREE);
      VAR MT:LIST;
   BEGIN
      IF LB <> NIL THEN BEGIN
         WHILE (LB <> LE) DO BEGIN
            NEW(MT);
            LE^.F:=MT;  LE:=MT;
            MELD(LB^.TREE,LB^.F^.TREE,MT^.TREE);
            MT:=LB^.F^.F;
            DISPOSE(LB^.F);  DISPOSE(LB);
            LB:=MT
         END;
         T:=LB^.TREE
      END
      ELSE T:=NIL
   END; {HEAPIFY}
   PROCEDURE PURGE(VAR LB,LE:LIST;VAR T:LTREE);
      VAR LL:LIST;
   BEGIN
      IF T <> NIL THEN
         IF T^.DEL THEN BEGIN
            PURGE(LB,LE,T^.L);
            PURGE(LB,LE,T^.R)
         END
         ELSE BEGIN
            NEW(LL);
            IF LB=NIL THEN BEGIN
               LB:=LL;  LE:=LL
            END;
            LE^.F:=LL;
            LL^.F:=NIL;  LL^.TREE:=T;
            LE:=LL
         END
   END; {PURGE}
BEGIN  {FIND_MIN}
   LB:=NIL;  LE:=NIL;
   PURGE(LB,LE,T);
   HEAPIFY(LB,LE,T)
END; {FIND_MIN}

PROCEDURE ADD_Q(K:INTEGER;T:LTREE);
   VAR LL:LIST;
BEGIN
   NEW(LL);
   IF QE=NIL THEN QB:=LL
   ELSE QE^.F:=LL;
   LL^.B:=QE;  LL^.F:=NIL;
   LL^.TREE:=T;
   QE:=LL;
   H[K]:=LL
END; {ADD_Q}

PROCEDURE DEL_Q(K:INTEGER);
   VAR L:LIST;
BEGIN
   L:=H[K];
   IF QB=QE THEN BEGIN
      QB:=NIL; QE:=NIL END
   ELSE IF L=QB THEN BEGIN
           QB:=L^.F;  QB^.B:=NIL
        END
        ELSE IF L=QE THEN BEGIN
                QE:=L^.B;  QE^.F:=NIL
             END
             ELSE BEGIN
                L^.B^.F:=L^.F;
                L^.F^.B:=L^.B
             END;
END; {DEL_Q}

FUNCTION FIND(II:INTEGER):INTEGER;
   VAR PTR:INTEGER;
BEGIN
   PTR:=II;
   WHILE FATHER[PTR] > 0 DO PTR:= FATHER[PTR];
   FIND:=PTR
END;  { FIND }

PROCEDURE UNION(I,J,K:INTEGER);
   VAR X:INTEGER;
BEGIN
   X:=FATHER[I]+FATHER[J];
   IF K=J THEN FATHER[I]:=J
   ELSE FATHER[J]:=I;
   FATHER[K]:=X
END;  { UNION }

PROCEDURE PRESEARCH(T:LTREE);
BEGIN
   IF T <> NIL THEN BEGIN
      IF (FIND(T^.V1)=I) AND (FIND(T^.V2)=I) THEN BEGIN
         T^.DEL:=TRUE;  T^.MATCH^.DEL:=TRUE
      END;
      PRESEARCH(T^.L);
      PRESEARCH(T^.R)
   END
END; {PRESEARCH}

BEGIN                                           { MAIN BODY }
   NEW(P);  P^.B:=NIL;
   P^.TREE:=NIL;  H[1]:=P;
   QB:=P;
   FOR I:=2 TO N DO BEGIN
      NEW(Q);  Q^.B:=P;  Q^.TREE:=NIL;
      P^.F:=Q;  H[I]:=Q;  P:=Q
   END;
   P^.F:=NIL;  QE:=P;

   FOR K:=1 TO M DO BEGIN
      NEW(LT1);
      WITH LT1^ DO BEGIN
         V1:=ENDV1[K];  V2:=ENDV2[K];  KEY:=WEIGHT[K];
         DEL:=FALSE;  L:=NIL;  R:=NIL;  RANK:=1;
         MELD(LT1,H[ENDV1[K]]^.TREE,H[ENDV1[K]]^.TREE)
      END;
      NEW(LT2);
      WITH LT2^ DO BEGIN
         V1:=ENDV2[K];  V2:=ENDV1[K];  KEY:=WEIGHT[K];
         DEL:=FALSE;  L:=NIL;  R:=NIL;  RANK:=1;
         MELD(LT2,H[ENDV2[K]]^.TREE,H[ENDV2[K]]^.TREE)
      END;
      LT1^.MATCH:=LT2;  LT2^.MATCH:=LT1
   END; {INITIAL HEAPS}

   FOR I:=1 TO N DO
      IF H[I]^.TREE=NIL THEN DEL_Q(I);

   FOR I:=1 TO N DO FATHER[I]:=-1;
   TCOUNT:=0;  TWEIGHT:=0;

   WHILE (QB <> QE) DO BEGIN
      LT1:=QB^.TREE;
      FIND_MIN(LT1);
      IF LT1 <> NIL THEN
         WITH LT1^ DO BEGIN
            DEL:=TRUE;  MATCH^.DEL:=TRUE;
            TCOUNT:=TCOUNT+1;
            TEDGE1[TCOUNT]:=V1;  TEDGE2[TCOUNT]:=V2;
            V:=V1;  W:=V2;
            TWEIGHT:=TWEIGHT+KEY;
            I:=FIND(V1);  J:=FIND(V2);
            UNION(I,J,I);
            PRESEARCH(LT1);
            L_MELD(H[I]^.TREE,H[J]^.TREE,HH);
            DEL_Q(I); DEL_Q(J);
            IF HH <> NIL THEN ADD_Q(I,HH)
         END
      ELSE QB:=QB^.F
   END {ITERATION}
END;  { SOLIN }


END.